///////////////////////////////////////////////////////////////////////////////
//
// This program is part of the Open Inventor Medical example set.
//
// Open Inventor customers may use this source code to create or enhance
// Open Inventor-based applications.
//
// The medical utility classes are provided as a prebuilt library named
// "fei.inventor.Medical", that can be used directly in an Open Inventor
// application. The classes in the prebuilt library are documented and
// supported by Thermo Fisher Scientific. These classes are also provided as source code.
//
// Please see $OIVHOME/include/Medical/InventorMedical.h for the full text.
//
///////////////////////////////////////////////////////////////////////////////
//!oiv_include <VolumeViz/vvizfnc_frag.h>

// uniform identifying the SoTexture2 node. the name of the uniform (MyTexture) must correspond to the name
// of SoShaderParameter1i attached to SoFragmentShader.
uniform sampler2D MyTexture;

vec4 VVizComputeFragmentColor(VVIZ_DATATYPE vox, vec3 texCoord)
{
  // Apply colormap and other effects to data
  vec4 colorVolume = VVizComputeVolumeRendering(vox);

  // retrieve the color of SoTexture2 node.
  // texCoord is given in volume space, ie (0, 0, 0) is lower left bottom corner, (1, 1, 1) is upper right top corner,
  // relative to the whole volume.
  // This imply that if a slice is across X axis, texCoord.yz should be used to cover the slice surface.
  vec4 colorTex = texture(MyTexture, texCoord.xy);
 
  // compose the 2 color. Here, we just modulate the red component of SoTexture2
  // with the default color of Slice
  vec4 finalColor = colorTex.x * colorVolume;

  // return the final color
  return finalColor;
}

